<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 11.12.13 15:14
 */

namespace VM\AdminBundle\Services;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

class AuthCommunication
{
    /**
     * @var string
     */
    protected $authUrl;

    /**
     * Application Key
     *
     * @var string
     */
    protected $authAppKey;


    /**
     * Curl request object
     *
     * @var
     */
    protected $curlRequest;



    public function __construct($authUrl, $authAppKey)
    {
        $this->authUrl = $authUrl;
        $this->authAppKey = $authAppKey;
    }


    public function createProduct($name, $productCategory = 'SIMPLE_REPORT', $description = '', $productType = 'PC', $image = false)
    {
        if(empty($image) || !file_exists($image))
        {
            $image = __DIR__ . '/../Resources/public/gfx/gb-logo.png';
        }
        $this->initConnection();
        $data = array(
            'name' => $name,
            'description' => $description,
            'productType' => $productType,
            'productCategory' => $productCategory,
            'imgContent' => base64_encode(file_get_contents($image))
        );
        return $this->executeAndGetResponse('createProduct', $data);
    }


    public function uploadContent($productCode, $content, $checksum, $version, $type = 'FLASH')
    {
        $this->initConnection();
        $data = array(
            'productCode' => $productCode,
            'content' => $content,
            'checksum' => $checksum,
            'version' => $version,
            'type' => $type
        );
        return $this->executeAndGetResponse('uploadContent', $data);
    }

    public function connectUsersToProduct($productCode, $ssoUserIds)
    {
        $this->initConnection();
        $data = array(
            'productCode' => $productCode,
            'ssoUserIds' => $ssoUserIds
        );
        return $this->executeAndGetResponse('connectUsersToProduct', $data);
    }


    protected function initConnection()
    {
        $this->curlRequest = curl_init($this->authUrl);
    }



    protected function executeAndGetResponse($method, $data)
    {
        $data['securityKey'] = $this->authAppKey;
        $params = array(
            'params' => $data,
            'method' => $method,
        );


        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($params)
        );

        curl_setopt_array($this->curlRequest, $options);

        $response = curl_exec($this->curlRequest);

        $this->primaryValidation($response);

        return json_decode($response, true);
    }


    /**
     * @param $responseString
     * @throws \Exception
     */
    protected function primaryValidation($responseString)
    {
        $info = curl_getinfo($this->curlRequest);
        if($info['http_code'] != 200)
        {
            throw new \Exception('response is empty', 404);
        }

        $error = curl_error($this->curlRequest);
        if(!empty($error))
        {
            throw new \Exception($error, 1010);
        }

        if(empty($responseString))
        {
            throw new \Exception('response is empty', 1000);
        }

        $response = json_decode($responseString, true);
        if(isset($response['error']))
        {
            throw new \Exception('AUTH: '.$response['error']['message'], $response['error']['code']);
        }
    }
}